function [output] = lintest_stvar_LM(y,trans,translag)
%function [Lratio, Lprob, LM, LMprob, F, Fprob, Lambda, Lambdaprob, Rao, Raoprob] = lintest_stvar_LM(y,trans,translag)
% PURPOSE: performs linearity  in a STVAR model
%
%---------------------------------------------------
% USAGE:  result = lintests_stvar(y, nlag, trans, translag, func)
% where:    y    = a (nobs x k) vector
%           trans = transition variables (for each equation)
%           translag = lag of transition variable (for each equation)
%
%---------------------------------------------------
%
% written by:
% Frauke Schleer
% schleer@zew.de
%
% based on Weise (1999) -  The Asymmetric Effects of Monetary Policy - A
% Nonlinear VAR Approach

if nargin < 3
    error('Wrong # of arguments to lintest_stvar');
end

global_lintests

[nobs ,neqs] = size(y);
[nobs_trans ,neqs_trans] = size(trans);

transvar=zeros(nobs_trans,neqs_trans);

% transition variables
for i=1:neqs_trans
    tv=trans(:,i);
    tv = lag(tv,translag(i));
    transvar(:,i)=tv;
end

[junk,junk,lags]=lagselec_var(y,pmax,lagsel,ic,fd,steps,rounds,freq);
nlag=lags;
laglen=nlag;

trans_sort=sort(translag,'descend');
if (lags(end))<trans_sort(1)
    %error('If lagged variables as transition variable used, wrong truncation for zlag')
    laglen=trans_sort(1);
end

% to get covariance matrix (Frauke)
sigma0 = zeros(neqs,neqs);
sigma1= zeros(neqs,neqs);
res0=zeros(nobs-laglen,neqs);
res1=zeros(nobs-laglen,neqs);

for j=1:neqs

    xmat = mlag(y,nlag);
    zmat = mlag(y,nlag);

    xmatt = xmat(laglen+1:end,:);
    nobs=length(xmatt);
    xmat1= [ones(nobs,1) xmatt];

    if exog==1
        zmat1 = [ones(nobs,1) zmat(laglen+1:end,:)];
    else
        zmat1 = zmat(laglen+1:end,:);
    end

    tvar = transvar(laglen+1:end,j);
    [junk,col]=size(zmat1);
    tvar=repmat(tvar,[1 col]);

    zmat1=zmat1.*tvar;
    zmat2=zmat1.*(tvar.^2);
    zmat3=zmat1.*(tvar.^3);

    %reg_log =[xmat1 zmat1];% Tersvirta (1994)
    reg_log =[xmat1 zmat1 zmat2 zmat3];% Tersvirta (1994)

    yvec = y(laglen+1:end,j);

    %get unrestricted residuls
    results_ur = ols(yvec,reg_log);
    res1(:,j)= results_ur.resid;
    results_res = ols(yvec,xmat1); %restricted regression
    res0(:,j) = results_res.resid;
    
    %auxilliary regression with FIRST order taylor approx.
    %res0vec=res0(:,j);
    %results_aux=ols(res0vec,[xmat1 zmat1]);
    %res00(:,j)=results_aux.resid;
    
    %auxilliary regression with THIRD order taylor approx.
    res0vec=res0(:,j);
    results_aux=ols(res0vec,reg_log);
    res00(:,j)=results_aux.resid;

end

for i=1:neqs;
    for j=1:neqs;
        sigma0(i,j) = (res0(:,i)'*res0(:,j))/(nobs-laglen);
        if j > 1;
            sigma0(j,i) = sigma0(i,j);
        end;
    end
end

for i=1:neqs;
    for j=1:neqs;
        sigma1(i,j) = (res1(:,i)'*res1(:,j))/(nobs-laglen);
        if j > 1;
            sigma1(j,i) = sigma1(i,j);
        end;
    end
end

output=zeros(5,2);

Lratio = nobs*(log(det(sigma0)) - log(det(sigma1)));
%Lprob = 1-chis_prb(Lratio,(3*(nlag+exog)*neqs^2)); %Frauke
Lprob = 1-chis_prb(Lratio,3*neqs*(nlag*neqs+const));
output(1,1)=Lratio; output(1,2)=Lprob;

%matrix residual sum of squares RSS_0 and RSS_1
RSS0 = res0'*res0;
RSS1 = res00'*res00;

%LM-statistic
LM = nobs*(neqs - trace(inv(RSS0)*RSS1));
%LMprob = 1-chis_prb(LM,neqs*(neqs*nlag+1)); %first order approx df
LMprob = 1-chis_prb(LM,3*neqs*(nlag*neqs+const)); 
output(2,1)=LM; output(2,2)=LMprob;


%IMPROVING THE SIZE OF THE LM-TEST (p.68 ff. Yang(2012))

%RESCALED LM TEST
%K = number of estimated parameters 
%G = number of restrictions
[junk ix] = size(xmat1);
[junk iz] = size([zmat1 zmat2 zmat3]);
[iT ip] = size(res0);
K = ix + iz;
G = iz*ip;

F = (neqs*nobs-K)/(G*neqs*nobs)*LM;
Fprob = 1 - fcdf(F,G,neqs*nobs-K);
output(3,1)=F; output(3,2)=Fprob;

%WILKS LAMBDA 
%with Bartlett's Approximation for large T (cf. Bartlett 1954)
Lambda = log(det(RSS1)) - log(det(RSS0));
Lambda = Lambda*((ip+iz)*.5 + ix - iT);
Lambdaprob=1 - chis_prb(Lambda,G);
output(4,1)=Lambda; output(4,2)=Lambdaprob;

%RAO'S TEST
iN = iT - ix - (ip+iz+1)*.5;
is = sqrt( (iz^2*ip^2-4) / (iz^2*ip^2-5));
Rao = exp((log(det(RSS0)) - log(det(RSS1)))/is) - 1;
Rao = Rao*(iN*is - iz*ip*.5 + 1)/(iz*ip);
Raoprob = 1- fcdf(Rao,(iz*ip),(iN*is - iz*ip*.5 + 1)); 
output(5,1)=Rao; output(5,2)=Raoprob;

%fprintf('The output gives the test statistics of LR, LM, rescaled LM, Wilks, Raos and the corresponding p-values');
end









